//
//  OPGameController.h
//  The Obfuscated Path
//
//  Created by ss2cire on 12/6/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OPModeController.h"
#import "OPTypes.h"

@class OPRoom;
@class OPTextureManager;
@class OPSprite, OPPlayer;
@class OPMap;
@class OPTrigger;
@class OPHUDView;
@class OPItem;

@interface OPGameController : OPModeController
{
	OPPlayer				*player;
	OPMap					*currentMap;
	NSMutableDictionary		*gameMaps;
	NSMutableDictionary		*eventStateDictionary;
	OPHUDView				*HUDView;
	BOOL					scrollingRoom;
}
- (void)loadTextureList;
- (void)loadGameMaps;

- (void)keyDown:(NSEvent *)event;
- (void)keyUp:(NSEvent *)event;
- (void)mouseDown:(NSEvent *)event;
- (void)mouseUp:(NSEvent *)event;
- (void)mouseDragged:(NSEvent *)event;
- (void)mouseMoved:(NSEvent *)event;

- (void)checkPlayerCollisions;
- (void)checkWeaponCollision;

- (void)checkEnemyCollisions;

- (void)checkEvents;
- (void)runEvent:(OPTrigger *)event;

- (void)checkRoomEdgeCollision;
- (void)checkItemCollision;
- (void)doActionForItem:(OPItem *)anItem;

- (void)loadPlayerTextures;
- (void)loadEnemyTextures;

- (void)setPlayer:(id)inPlayer;
- (id)player;

- (void)spawnEnemy:(NSNotification *)notification;
- (void)createItem:(NSNotification *)notification;
@end

@interface OPGameController (OPRoomEventActions)
- (void)movePlayer:(OPPoint)toPoint;
- (void)loadMap:(NSString *)mapName;
- (void)setRoom:(OPPoint)theRoom;
- (void)spawnItem:(OPTrigger *)trigger;
- (void)removeTree:(OPTrigger *)trigger;
- (void)hurtPlayer:(OPTrigger *)trigger;
@end
